//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System;
using Microsoft.Practices.EnterpriseLibrary.Configuration.Factory;
using Microsoft.VisualStudio.QualityTools.UnitTesting.Framework;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection.Tests
{
	[TestClass]
	public class InjectionFactoryFixture
	{
		
		[TestMethod]
		[ExpectedException(typeof(InvalidOperationException))]
		public void CreateWithBadConfigurationThrows()
		{
			InjectionFactory<ObjectToCreate, BadObjectConfiguration> factory = new InjectionFactory<ObjectToCreate, BadObjectConfiguration>();
			factory.Create(new BadObjectConfiguration("bob", 42));
		}

        //[TestMethod]
        //[ExpectedException(typeof(InvalidOperationException))]
        //public void CreateWithBadConfigurationDataTypeAsIObjectFactoryThrows()
        //{
        //    IObjectFactory<ObjectToCreate, ObjectConfiguration> factory = new InjectionFactory<ObjectToCreate, ObjectConfiguration>();
        //    factory.Create(new BadObjectConfiguration("bob", 42));
        //}

        //[TestMethod]
        //[ExpectedException(typeof(InvalidOperationException))]
        //public void CreateWithBadConfigurationDataTypeAsIObjectFactoryWithConfigurationSourceThrows()
        //{
        //    IObjectFactory<ObjectToCreate, ObjectConfiguration> factory = new InjectionFactory<ObjectToCreate, ObjectConfiguration>();
        //    factory.Create(new BadObjectConfiguration("bob", 42), new NullConfigurationSource());
        //}

		[TestMethod]
		public void Create()
		{
			InjectionFactory<ObjectToCreate, ObjectConfiguration> factory = new InjectionFactory<ObjectToCreate, ObjectConfiguration>();
			ObjectToCreate ob =factory.Create(new ObjectConfiguration("bob"));

			Assert.IsNotNull(ob);
			Assert.AreEqual<string>("bob", ob.Name);
		}

		[TestMethod]
		[ExpectedException(typeof(InvalidOperationException))]
		public void CreateWithBadPropertyConfigurationObject()
		{
			InjectionFactory<ObjectToCreate, BadPropertyNameObjectConfiguration> factory = new InjectionFactory<ObjectToCreate, BadPropertyNameObjectConfiguration>();
			ObjectToCreate ob = factory.Create(new BadPropertyNameObjectConfiguration("bob", 42));			
		}

		class ObjectToCreate
		{
			private readonly string name;

			public ObjectToCreate(string name)
			{
				this.name = name;
			}

			public string Name
			{
				get { return name; }
			}
		}

		[PropertyParameterAttribute(0, typeof(string), "Name")]
		class ObjectConfiguration
		{
			private readonly string name;

			public ObjectConfiguration(string name)
			{
				this.name = name;
			}

			public string Name
			{
				get { return name; }
			}
		}


		[PropertyParameterAttribute(0, typeof(string), "Name")]
		[PropertyParameterAttribute(1, typeof(int), "Age")]
		class BadObjectConfiguration
		{
			private readonly string name;
			private readonly int age;

			public BadObjectConfiguration(string name, int age)
			{
				this.name = name;
				this.age = age;
			}

			public string Name
			{
				get { return name; }
			}

			public int Age
			{
				get { return age; }
			}
		}

		[PropertyParameterAttribute(0, typeof(string), "Name")]
		[PropertyParameterAttribute(1, typeof(int), "Age2")]
		class BadPropertyNameObjectConfiguration
		{
			private readonly string name;
			private readonly int age;

			public BadPropertyNameObjectConfiguration(string name, int age)
			{
				this.name = name;
				this.age = age;
			}

			public string Name
			{
				get { return name; }
			}

			public int Age
			{
				get { return age; }
			}
		}
	}
}
